
USE master
GO
ALTER DATABASE BD_Air_France
ADD FILEGROUP  FG_FTS_Air_France;
GO
ALTER DATABASE BD_Air_France
ADD FILE 
(
    NAME     = fts_air_france,
    FILENAME = 'C:\Program Files\Microsoft SQL Server\MSSQL11.MSSQLSERVER\MSSQL\DATA\fts_air_france.ndf',
    SIZE     = 5MB,
    MAXSIZE  = 100MB,
    FILEGROWTH = 5MB
)
TO FILEGROUP FG_FTS_Air_France;
GO


USE BD_Air_France;

CREATE FULLTEXT CATALOG FTC_catalogue
    ON FILEGROUP FG_FTS_Air_France
    WITH ACCENT_SENSITIVITY = OFF
    AS DEFAULT;

CREATE TABLE T_livre_lvr
(lvr_id                 INT NOT NULL CONSTRAINT pk_lvr PRIMARY KEY,
 lvr_titre               VARCHAR(256) NOT NULL,
 lvr_annee_parution      SMALLINT,
 lvr_resume              VARCHAR(MAX),
 lvr_format_fichier      CHAR(4),
 lvr_texte_integral       VARBINARY(MAX));

INSERT INTO T_livre_lvr (lvr_id, lvr_titre, lvr_annee_parution, lvr_resume)
VALUES (1, 'La photographie d''Internet', 1995, 'Le rseau mondial dvoil');

INSERT INTO T_livre_lvr (lvr_id, lvr_titre, lvr_annee_parution, lvr_resume)
VALUES (2, 'HTML et XML', 2012,'Comment ces deux langages se compltent.');

-- avec un .rtf

INSERT INTO T_livre_lvr 
  (lvr_format_fichier, lvr_id, lvr_titre, 
lvr_annee_parution, lvr_resume, lvr_texte_integral)
SELECT '.rtf', 3, 'SQL pour les pros', 2012, 'SQL syntaxe et exemples',
 BULKCOLUMN FROM OPENROWSET
  (BULK 'C:\dev\FTS\sql-pro.rtf',SINGLE_BLOB) AS BLOB;

-- avec un .doc

UPDATE T_livre_lvr
SET    lvr_format_fichier = '.doc',
       lvr_texte_integral = (SELECT BULKCOLUMN 
        FROM OPENROWSET
(BULK 'C:\dev\FTS\\chap-xml.doc', SINGLE_BLOB) AS BLOB)
WHERE  lvr_id = 2;


CREATE FULLTEXT INDEX
    ON T_livre_lvr (lvr_titre  LANGUAGE French,
                    lvr_resume LANGUAGE French,
                    lvr_texte_integral TYPE COLUMN lvr_format_fichier LANGUAGE French)
    KEY INDEX pk_lvr
    ON FTC_catalogue
    WITH  CHANGE_TRACKING MANUAL,  STOPLIST = SYSTEM;


SELECT lvr_id,lvr_titre,lvr_annee_parution 
FROM   T_livre_lvr
WHERE  CONTAINS(lvr_texte_integral, '"SQL Server" 
           OR ("filegroup" AND "filestream")');

-- proximit 

SELECT lvr_id,lvr_titre
FROM   T_livre_lvr
WHERE CONTAINS(lvr_texte_integral, 'NEAR((CTE,member), 1, TRUE)');
 
--forme flchie

SELECT lvr_titre,lvr_resume
FROM   T_livre_lvr
WHERE CONTAINS((lvr_titre, lvr_resume),
         ' FORMSOF(INFLECTIONAL,"complter") ', LANGUAGE 'French');

-- thesaurus dans 
-- C:\Program Files\Microsoft SQL Server\MSSQL11.MSSQLSERVER\MSSQL\FTData\tsfra.xml

EXEC sys.sp_fulltext_load_thesaurus_file 1036;
GO

-- synonyme / expansion

SELECT lvr_id, lvr_titre
FROM   T_livre_lvr
WHERE CONTAINS((lvr_titre),
         'FORMSOF(THESAURUS, "toile")', LANGUAGE 'French');

SELECT lvr_id,lvr_titre
FROM   T_livre_lvr
WHERE CONTAINS((lvr_titre),
         'FORMSOF(THESAURUS, "langage de balises")', LANGUAGE 'French');             

-- Expression

SELECT lvr_id, lvr_titre,lvr_resume
FROM   T_livre_lvr
WHERE CONTAINS((lvr_titre,lvr_resume),
         '"deux langages"', LANGUAGE 'French');

-- Mot avec joker 

SELECT lvr_id, lvr_titre,lvr_resume
FROM   T_livre_lvr
WHERE CONTAINS((lvr_titre,lvr_resume),
         '"SQ*"', LANGUAGE 'French');

--- fonctions table

SELECT Key_table.RANK,lvr_id,lvr_titre
FROM   T_livre_lvr AS Doc_table INNER JOIN
       CONTAINSTABLE (T_livre_lvr,
                     lvr_texte_integral, 
                 '("SQL" NEAR "Server") OR ("filegroup" AND "filestream")') AS Key_table
         ON Doc_table.lvr_id = Key_table.[KEY]
WHERE    Key_table.RANK > 10
ORDER BY Key_table.RANK DESC;


-- pondration

SELECT Key_table.RANK,lvr_id,lvr_titre
FROM   T_livre_lvr AS Doc_table INNER JOIN
       CONTAINSTABLE(T_livre_lvr,
                     lvr_texte_integral, 
              'ISABOUT ("index", textuel WEIGHT(0.9), fragment WEIGHT(0.1))' ) AS Key_table
       ON Doc_table.lvr_id = Key_table.[KEY]
ORDER BY Key_table.RANK DESC;


DROP FULLTEXT INDEX ON T_livre_lvr ;
DROP  FULLTEXT CATALOG FTC_catalogue;
DROP TABLE T_livre_lvr;